/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.ProblemReporter;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.RsfResult;
import com.ibm.hwmca.fw.rsf.RsfResultDetails;
import com.ibm.hwmca.fw.rsf.RsfResultProcessor;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.PIProblemDataConstants;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.rsf.I_P_ProblemReportAttributes;
import com.ibm.hwmca.p.rsf.I_P_ProblemReportRequestBody;
import com.ibm.hwmca.p.sa.PIProblemCustomerNotifier;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import com.ibm.hwmca.xfw.pa.attention.CommonProblemAttention;
import com.ibm.hwmca.xfw.pa.attention.RSFCompletionAttention;
import com.ibm.hwmca.xfw.pa.attention.RSFFailureAttention;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import com.ibm.hwmca.xfw.rsf.RsfFru;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class PIProblemReporter
implements ProblemReporter,
RsfResultProcessor,
I_P_ProblemReportAttributes,
PIProblemDataConstants,
ServiceAgentAttr {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private static final String CLASS_NAME = "[PIProblemReporter] ";
    private static final int MAX_LOW_SPEED_SIZE = 0xE00000;
    private static final int MAX_HIGH_SPEED_SIZE = 0x4000000;
    private static final int MAX_TEXT_LINES_LENGTH = 72;

    public void reportProblem(Problem problem) throws HException {
        Trace.trace(TRACE_MASKT, "[PIProblemReporter] --> reportProblem");
        if (ServiceAgentUtils.isOEM()) {
            ServiceAgentUtils.notifyOEM("ProblemCallHome", problem);
        } else if (problem instanceof PIProblem) {
            PIProblem theProblem = (PIProblem)problem;
            ServiceAgentAttr.ESAreportingMachInfo rep = ServiceAgentUtils.getReportingMachineInfo(theProblem);
            boolean RSFSetting = ServiceAgentUtils.ESACheckRSF(rep.machType, rep.machModel, rep.machSerial);
            if (RSFSetting) {
                byte block = 3;
                Log theLog = new Log(-86, -45, 0, "SaPAPOpeReq", null, null, null, null);
                I_P_ProblemReportRequestBody body = new I_P_ProblemReportRequestBody();
                body.setStorageRequest(theProblem.isStorageRequest());
                Integer problemNumber = new Integer(theProblem.getProblemNumber());
                String sProblemNumber = problemNumber.toString();
                body.putAttribute("Problem Number", sProblemNumber);
                body.putAttribute("Severity", "3");
                String symptomString = theProblem.getSymptomString();
                if (symptomString == null) {
                    symptomString = "SymptomStringNotSet";
                }
                body.putAttribute("Symptom String", symptomString);
                Trace.trace(TRACE_MASKF, "[PIProblemReporter] --> RSF_SYMPTOM_STRING = " + body.getAttribute("Symptom String"));
                String componentID = "";
                String Refcode = theProblem.getRefcode();
                if (Refcode != null) {
                    componentID = Refcode.startsWith("1") ? "9100SPC00" : (Refcode.startsWith("B1") || Refcode.startsWith("B4") ? "9100FSP00" : (Refcode.startsWith("B2") || Refcode.startsWith("B7") ? "9100PHY00" : (Refcode.startsWith("BB") || Refcode.startsWith("BC") ? "9100FED00" : (Refcode.startsWith("E2") || Refcode.startsWith("E3") || Refcode.startsWith("B3") ? "9100HMC00" : "9100PFW00"))));
                } else {
                    Trace.trace(TRACE_MASKF, "[PIProblemReporter] getRefcode: not set");
                    Refcode = "not set";
                }
                body.putAttribute("Component Id", componentID);
                String Extension = theProblem.getExtension();
                if (Extension == null) {
                    Extension = "not set";
                }
                body.setReportingMachineInfo(new RsfMachineInfo(rep.machType, rep.machModel, rep.machSerial));
                if (theProblem.getFailingSystem() != null) {
                    String devmachType = theProblem.getFailingSystem().getMachineType();
                    String devmachModel = theProblem.getFailingSystem().getMachineModel();
                    String devmachSerial = theProblem.getFailingSystem().getMachineSerial();
                    body.setFailingDeviceInfo(new RsfMachineInfo(devmachType, devmachModel, devmachSerial));
                }
                if (theProblem.getCalledHomeSystem() != null) {
                    if (theProblem.getCalledHomeSystem().getMO() != null) {
                        body.initializeUpdateInfo(theProblem.getCalledHomeSystem().getMO());
                    } else {
                        body.initializeUpdateInfo();
                    }
                } else {
                    body.initializeUpdateInfo();
                }
                String[] textLines = null;
                textLines = theProblem.getPmrNotelog();
                if (textLines == null || textLines.length == 0) {
                    String serviceableEventText;
                    Trace.trace(TRACE_MASKF, "[PIProblemReporter] building NOTELOG");
                    String locationCode = "";
                    ArrayList<String> textArea = new ArrayList<String>();
                    List parts = theProblem.getParts();
                    CommonPaFru paFru = null;
                    ArrayList<RsfFru> frus = new ArrayList<RsfFru>();
                    textArea.add("** Service Agent Reported **");
                    textArea.add("Refcode: " + Refcode + "    Extension: " + Extension);
                    String dateReported = "not set";
                    if (theProblem.getFirstReportedTimestamp() > 0L) {
                        long firstReported = theProblem.getFirstReportedTimestamp();
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                        dateReported = df.format(new Date(firstReported));
                    }
                    textArea.add("First Reported Time:         " + dateReported);
                    String hmcFwLevel = ServiceAgentUtils.getHmcFwLevel();
                    if (hmcFwLevel == null || hmcFwLevel.length() <= 0) {
                        hmcFwLevel = "HMC FW Level: not set";
                        textArea.add(hmcFwLevel);
                    } else {
                        textArea.add("HMC FW Level: ");
                        int lines = hmcFwLevel.length() / 72;
                        for (int i = 0; i < lines; ++i) {
                            textArea.add(hmcFwLevel.substring(i * 72, i * 72 + 72));
                        }
                        int remain = hmcFwLevel.length() % 72;
                        if (remain > 0) {
                            textArea.add(hmcFwLevel.substring(lines * 72, lines * 72 + remain));
                        }
                    }
                    if (parts != null) {
                        Trace.trace(TRACE_MASKF, "[PIProblemReporter] parts.size() = " + parts.size());
                        for (int i = 0; i < parts.size(); ++i) {
                            paFru = (CommonPaFru)parts.get(i);
                            Trace.trace(TRACE_MASKF, "[PIProblemReporter] paFru.getPartNumber[" + paFru.getPartNumber() + "]");
                            RsfFru fru = new RsfFru("  ", paFru.getPartNumber(), "  ");
                            frus.add(fru);
                            textArea.add("FRU Part Number:   " + paFru.getPartNumber());
                            textArea.add("FRU Serial Number: " + paFru.getSerialNumber());
                            if (paFru.getLocationList().size() > 0) {
                                ArrayList locCodes = paFru.getLocationList();
                                String locPrefix = "FRU Location Code: ";
                                for (int j = 0; j < locCodes.size(); ++j) {
                                    textArea.add(locPrefix + (String)locCodes.get(j));
                                    locPrefix = "                   ";
                                }
                            } else {
                                textArea.add("FRU Location Code: ");
                            }
                            String fruPrevProblemNumber = "";
                            String fruPrevPMH = "";
                            String fruPrevReplaceDate = "";
                            String fruPrev = paFru.getPartNumber();
                            if (fruPrev != null && fruPrev.trim().length() > 0) {
                                PASystem failingSystem = theProblem.getFailingSystem();
                                Problem prevProblem = ServiceAgentUtils.getFruPreviousProblem(fruPrev.trim(), problem, theProblem.getFailingSystem());
                                if (prevProblem != null) {
                                    long fruReplacedTimeStamp;
                                    fruPrevProblemNumber = Integer.toString(prevProblem.getProblemNumber());
                                    CommonProblem cProblem = (CommonProblem)prevProblem;
                                    fruPrevPMH = cProblem.getPMH();
                                    if (fruPrevPMH == null || fruPrevPMH.length() == 0) {
                                        fruPrevPMH = "NoPMH";
                                    }
                                    if ((fruReplacedTimeStamp = ServiceAgentUtils.getFruReplacedTimeStamp(fruPrev.trim(), prevProblem, theProblem.getFailingSystem())) > 0L) {
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                                        fruPrevReplaceDate = df.format(new Date(fruReplacedTimeStamp));
                                    }
                                }
                            }
                            textArea.add("FRU Previous Problem Number: " + fruPrevProblemNumber);
                            textArea.add("FRU Previous PMH:            " + fruPrevPMH);
                            textArea.add("FRU Previous Replace Date:   " + fruPrevReplaceDate);
                        }
                        body.setFruList(frus);
                    }
                    if ((serviceableEventText = theProblem.getServiceableEventText().toString(Locale.US)) == null || serviceableEventText.length() <= 0) {
                        serviceableEventText = "Serviceable Event Text: N/A";
                        textArea.add(serviceableEventText);
                    } else {
                        textArea.add("Serviceable Event Text: ");
                        int lines = serviceableEventText.length() / 72;
                        for (int i = 0; i < lines; ++i) {
                            textArea.add(serviceableEventText.substring(i * 72, i * 72 + 72));
                        }
                        int remain = serviceableEventText.length() % 72;
                        if (remain > 0) {
                            textArea.add(serviceableEventText.substring(lines * 72, lines * 72 + remain));
                        }
                    }
                    String partitionName = theProblem.getPartitionName();
                    if (partitionName == null || partitionName.length() <= 0) {
                        partitionName = "N/A";
                    }
                    textArea.add("Partition Name:              " + partitionName);
                    String partitionHostName = theProblem.getPartitionHostName();
                    if (partitionHostName == null || partitionHostName.length() <= 0) {
                        partitionHostName = "N/A";
                    }
                    textArea.add("Partition Host Name:         " + partitionHostName);
                    textLines = textArea.toArray(new String[textArea.size()]);
                    for (int tLine = 0; tLine < textLines.length; ++tLine) {
                        Trace.trace(TRACE_MASKF, "[PIProblemReporter] PmrNotelog[" + tLine + "] = " + textLines[tLine]);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[PIProblemReporter] successfully retrieved NOTELOG from problem");
                    for (int tLine = 0; tLine < textLines.length; ++tLine) {
                        Trace.trace(TRACE_MASKF, "[PIProblemReporter] PmrNotelog[" + tLine + "] = " + textLines[tLine]);
                    }
                }
                body.putAttribute("Notelog", body.buildNotelog(textLines));
                ServiceAgentAttr.ESApapRequest papRequest = new ServiceAgentAttr.ESApapRequest();
                papRequest.requestType = "Problem_Open";
                papRequest.problemUUID = theProblem.getUniqueKey();
                body.setUserAttachement(papRequest);
                RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
                if (rsf != null) {
                    RsfRequest req = rsf.newRequestInstance(body, this.getClass().getName(), new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cat.problem"));
                    if (req != null) {
                        req.submit();
                        theLog.add((byte)3, req.getId());
                        block = (byte)(block + 1);
                        theLog.add(block, body.toString());
                        theLog.log();
                    } else {
                        Trace.trace(TRACE_MASKF, "[PIProblemReporter] req was null");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[PIProblemReporter] rsf was null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[PIProblemReporter] rsf not enabled");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[PIProblemReporter] not a PIProblem");
        }
        Trace.trace(TRACE_MASKT, "[PIProblemReporter] <-- reportProblem");
    }

    public void rsfRequestCompleted(RsfRequest request, RsfResult result) {
        Trace.trace(TRACE_MASKT, "[PIProblemReporter] --> rsfRequestCompleted");
        PIProblem theProblem = null;
        ProblemManager pm = null;
        I_P_ProblemReportRequestBody body = (I_P_ProblemReportRequestBody)request.getBody();
        String problemNumber = body.getAttribute("Problem Number");
        ServiceAgentAttr.ESApapRequest papRequest = (ServiceAgentAttr.ESApapRequest)body.getUserAttachment();
        Trace.trace(TRACE_MASKF, "[PIProblemReporter] Working with problem number " + problemNumber);
        Trace.trace(TRACE_MASKF, "[PIProblemReporter] with uuid of " + papRequest.problemUUID);
        Trace.trace(TRACE_MASKT, "[PIProblemReporter] rsfRequestCompleted() status=" + result.getStatusMessage());
        try {
            pm = ProblemManager.getProblemManager();
            theProblem = (PIProblem)pm.getProblem(papRequest.problemUUID);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (theProblem != null) {
            CommonProblemAttention compAtten;
            HMC hmc;
            byte block = 3;
            Log theLog = new Log(-86, -45, 0, "SaPAPOpeRes", null, null, null, null);
            theLog.add((byte)3, request.getId());
            block = (byte)(block + 1);
            theLog.add(block, result);
            theLog.log();
            LocalizableText statusDetails = new LocalizableText();
            int status = result.getStatusCode();
            if (status == 1) {
                Trace.trace(TRACE_MASKF, "[PIProblemReporter] got a good rsf completion");
                RsfResultDetails details = result.getDetails();
                String detailsStatus = (String)details.getAttribute("Problem status");
                if (detailsStatus.equals("0114")) {
                    statusDetails = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.pmrstatus.open");
                } else if (detailsStatus.equals("0113")) {
                    statusDetails = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.pmrstatus.ce");
                } else if (detailsStatus.equals("0117")) {
                    statusDetails = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.pmrstatus.fix");
                    theProblem.getProblemData().add("pdc_FIRMWARE_FIX", statusDetails);
                } else {
                    statusDetails = new LocalizableText(detailsStatus);
                }
                String pmh = (String)details.getAttribute("pmh");
                Trace.trace(TRACE_MASKF, "[PIProblemReporter] pmh=" + pmh);
                theProblem.setPMH(pmh);
                theProblem.getProblemData().add("pdc_ESA_STATUS", statusDetails);
                theProblem.getProblemData().add("pdc_ESA_PMRSTATUS", result.getStatusMessage());
                theProblem.setNotificationStatus(statusDetails);
                if (theProblem.isGenerateAttention() && (hmc = HMC.getHMC()) != null) {
                    Trace.trace(TRACE_MASKF, "[PIProblemReporter] post the rsf completion attention");
                    compAtten = new RSFCompletionAttention(hmc.getObjectId(), new BaseMessageText("XPA1637"));
                    compAtten.setProblem(theProblem);
                    hmc.addAttention(compAtten);
                }
            } else if (status == 2) {
                Trace.trace(TRACE_MASKF, "[PIProblemReporter] rsf transmission failed");
                int reasonCode = result.getReasonCode();
                Trace.trace(TRACE_MASKF, "[PIProblemReporter] got a reason message of " + result.getReasonMessage());
                FrameworkEventText fet = null;
                switch (reasonCode) {
                    case 5: {
                        fet = new FrameworkEventText(680);
                        break;
                    }
                    case 1: {
                        fet = new FrameworkEventText(681);
                        break;
                    }
                    case 3: {
                        fet = new FrameworkEventText(679);
                        break;
                    }
                    case 7: {
                        fet = new FrameworkEventText(678);
                        break;
                    }
                    case 9: {
                        fet = new FrameworkEventText(826);
                        break;
                    }
                    default: {
                        fet = new FrameworkEventText(676);
                    }
                }
                SystemEventLog logEvent = new SystemEventLog(fet, "TRSFAIL");
                logEvent.log();
                statusDetails = result.getStatusMessage();
                theProblem.setNotificationStatus(statusDetails);
                theProblem.getProblemData().add("pdc_ESA_STATUS", new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.status.failed"));
                theProblem.getProblemData().add("pdc_ESA_PMRSTATUS", statusDetails);
                if (theProblem.isGenerateAttention() && (hmc = HMC.getHMC()) != null) {
                    compAtten = new RSFFailureAttention(hmc.getObjectId(), new BaseMessageText("XPA1637"));
                    compAtten.setProblem(theProblem);
                    hmc.addAttention(compAtten);
                }
            }
            List dList = theProblem.getProblemDataSet();
            if (dList != null) {
                for (int i = 0; i < dList.size(); ++i) {
                    ProblemDataDescriptor dd = (ProblemDataDescriptor)dList.get(i);
                    if (dd != null) {
                        Trace.trace(TRACE_MASKF, "[PIProblemReporter] working with type: " + dd.getType());
                        if (!dd.getType().equals("INIT_CALL_HOME_DATA_SET")) continue;
                        Trace.trace(TRACE_MASKF, "[PIProblemReporter] setCallHomeCandidate for: " + dd.getFileLocation());
                        dd.setCallHomeCandidate(true);
                        break;
                    }
                    Trace.trace(TRACE_MASKF, "[PIProblemReporter] dd was null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[PIProblemReporter] dList was null");
            }
            try {
                pm.changed(theProblem);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[PIProblemReporter] pm exception");
                Trace.trace(TRACE_MASKF, e);
            }
            PIProblemCustomerNotifier cn = new PIProblemCustomerNotifier();
            cn.repNotifyCustomer(theProblem);
        } else {
            Trace.trace(TRACE_MASKF, "[PIProblemReporter] theProblem was null");
        }
        Trace.trace(TRACE_MASKT, "[PIProblemReporter] <-- rsfRequestCompleted");
    }
}

